/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.control;

import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.MuseLogger;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;

public class KeybindManager {
    protected Set keybindings = new HashSet();
    protected static KeybindManager instance;

    protected KeybindManager() {
    }

    public static KeybindManager getInstance() {
        if (instance == null) {
            instance = new KeybindManager();
        }
        return instance;
    }

    public static Set getKeybindings() {
        return KeybindManager.getInstance().keybindings;
    }

    public static KeyBinding addKeybinding(String keybindDescription, int keycode, MusePoint2D position) {
        KeyBinding kb = new KeyBinding(keybindDescription, keycode);
        boolean free = !KeyBinding.field_74514_b.func_76037_b(keycode);
        KeybindManager.getInstance().keybindings.add(new ClickableKeybinding(kb, position, free));
        return kb;
    }

    public static String parseName(KeyBinding keybind) {
        if (keybind.field_74512_d < 0) {
            return "Mouse" + (keybind.field_74512_d + 100);
        }
        return Keyboard.getKeyName((int)keybind.field_74512_d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOutKeybinds() {
        BufferedWriter writer = null;
        try {
            File file = new File(Loader.instance().getConfigDir(), "powersuits-keybinds.cfg");
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(file));
            List modulesToWrite = MuseItemUtils.getPlayerInstalledModules((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            for (ClickableKeybinding keybinding : KeybindManager.getInstance().keybindings) {
                writer.write(keybinding.getKeyBinding().field_74512_d + ":" + keybinding.getPosition().x() + ':' + keybinding.getPosition().y() + '\n');
                for (ClickableModule module : keybinding.getBoundModules()) {
                    writer.write(module.getModule().getName() + '~' + module.getPosition().x() + '~' + module.getPosition().y() + '\n');
                }
            }
        }
        catch (Exception e) {
            MuseLogger.logError("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void readInKeybinds() {
        try {
            File file = new File(Loader.instance().getConfigDir(), "powersuits-keybinds.cfg");
            if (!file.exists()) {
                MuseLogger.logError("No powersuits keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ClickableKeybinding workingKeybinding = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    int id = Integer.parseInt(exploded[0]);
                    if (!KeyBinding.field_74514_b.func_76037_b(id)) {
                        MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                        boolean free = !KeyBinding.field_74514_b.func_76037_b(id);
                        workingKeybinding = new ClickableKeybinding(new KeyBinding(Keyboard.getKeyName((int)id), id), position, free);
                        KeybindManager.getInstance().keybindings.add(workingKeybinding);
                        continue;
                    }
                    workingKeybinding = null;
                    continue;
                }
                if (!line.contains("~") || workingKeybinding == null) continue;
                exploded = line.split("~");
                MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                IPowerModule module = ModuleManager.getModule(exploded[0]);
                if (module == null) continue;
                ClickableModule cmodule = new ClickableModule(module, position);
                workingKeybinding.bindModule(cmodule);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logError("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }
}

