/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.control;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PlayerInputMap {
    protected static Map playerInputs = new HashMap();
    public PlayerInputMap lastSentMap;
    public float forwardKey;
    public float strafeKey;
    public boolean jumpKey;
    public boolean sneakKey;
    public boolean downKey;
    public double motionX;
    public double motionY;
    public double motionZ;

    public static PlayerInputMap getInputMapFor(String playerName) {
        PlayerInputMap map2 = (PlayerInputMap)playerInputs.get(playerName);
        if (map2 == null) {
            map2 = new PlayerInputMap(playerName);
        }
        return map2;
    }

    public PlayerInputMap(PlayerInputMap master) {
        this.setTo(master);
    }

    public PlayerInputMap(String playerName) {
        playerInputs.put(playerName, this);
        this.lastSentMap = new PlayerInputMap(this);
    }

    public boolean writeToStream(DataOutputStream stream) {
        try {
            stream.writeFloat(this.forwardKey);
            stream.writeFloat(this.strafeKey);
            stream.writeBoolean(this.jumpKey);
            stream.writeBoolean(this.sneakKey);
            stream.writeBoolean(this.downKey);
            stream.writeDouble(this.motionX);
            stream.writeDouble(this.motionY);
            stream.writeDouble(this.motionZ);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean readFromStream(DataInputStream stream) {
        try {
            this.forwardKey = stream.readFloat();
            this.strafeKey = stream.readFloat();
            this.jumpKey = stream.readBoolean();
            this.sneakKey = stream.readBoolean();
            this.downKey = stream.readBoolean();
            this.motionX = stream.readDouble();
            this.motionY = stream.readDouble();
            this.motionZ = stream.readDouble();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object obj) {
        try {
            PlayerInputMap other = (PlayerInputMap)obj;
            return other.forwardKey == this.forwardKey && other.strafeKey == this.strafeKey && other.jumpKey == this.jumpKey && other.sneakKey == this.sneakKey && other.downKey == this.downKey && other.motionX == this.motionX && other.motionY == this.motionY && other.motionZ == this.motionZ;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void setTo(PlayerInputMap master) {
        this.forwardKey = master.forwardKey;
        this.strafeKey = master.strafeKey;
        this.jumpKey = master.jumpKey;
        this.sneakKey = master.sneakKey;
        this.downKey = master.downKey;
        this.motionX = master.motionX;
        this.motionY = master.motionY;
        this.motionZ = master.motionZ;
    }

    public boolean hasChanged() {
        return this.equals(this.lastSentMap);
    }

    public void refresh() {
        this.lastSentMap.setTo(this);
    }
}

