/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import java.util.HashMap;
import java.util.Map;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.sound.Musique;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class MovementManager {
    public static Map playerJumpMultipliers = new HashMap();
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public static double getPlayerJumpMultiplier(EntityPlayer player) {
        if (playerJumpMultipliers.containsKey(player.field_71092_bJ)) {
            return (Double)playerJumpMultipliers.get(player.field_71092_bJ);
        }
        return 0.0;
    }

    public static void setPlayerJumpTicks(EntityPlayer player, double number) {
        playerJumpMultipliers.put(player.field_71092_bJ, number);
    }

    @ForgeSubscribe
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).func_82169_q(1)) != null && stack.func_77973_b() instanceof ItemPowerArmor && MuseItemUtils.itemHasActiveModule(stack, "Jump Assist")) {
            double jumpAssist = ModuleManager.computeModularProperty(stack, "Jump Boost") * 2.0;
            double drain = ModuleManager.computeModularProperty(stack, "Jump Energy Consumption");
            double avail = ElectricItemUtils.getPlayerEnergy(player);
            Musique.playerSound(player, "mods.mmmPowersuits.sound.JumpAssist", (float)(jumpAssist / 8.0), 2.0f, false);
            if (drain < avail) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                MovementManager.setPlayerJumpTicks(player, jumpAssist);
                double jumpCompensationRatio = ModuleManager.computeModularProperty(stack, "Jump Exhaustion Compensation");
                if (player.func_70051_ag()) {
                    player.func_71024_bL().func_75113_a((float)(-0.8 * jumpCompensationRatio));
                } else {
                    player.func_71024_bL().func_75113_a((float)(-0.2 * jumpCompensationRatio));
                }
            }
        }
    }

    @ForgeSubscribe
    public void handleFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (event.entityLiving instanceof EntityPlayer && (boots = (player = (EntityPlayer)event.entityLiving).func_82169_q(0)) != null && MuseItemUtils.itemHasActiveModule(boots, "Shock Absorber") && event.distance > 3.0f) {
            double distanceAbsorb = (double)event.distance * ModuleManager.computeModularProperty(boots, "Distance Reduction");
            Musique.playerSound(player, "mods.mmmPowersuits.sound.GUIInstall", (float)distanceAbsorb, 2.0f, false);
            double drain = distanceAbsorb * ModuleManager.computeModularProperty(boots, "Impact Energy consumption");
            double avail = ElectricItemUtils.getPlayerEnergy(player);
            if (drain < avail) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                event.distance = (float)((double)event.distance - distanceAbsorb);
            }
        }
    }

    public static double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        double distance = 0.03920000076293945 * ticks * ticks;
        return distance;
    }
}

