/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_SPRINT_ASSIST = "Sprint Assist";
    public static final String SPRINT_ENERGY_CONSUMPTION = "Sprint Energy Consumption";
    public static final String SPRINT_SPEED_MULTIPLIER = "Sprint Speed Multiplier";
    public static final String SPRINT_FOOD_COMPENSATION = "Sprint Exhaustion Compensation";
    public static final String WALKING_ENERGY_CONSUMPTION = "Walking Energy Consumption";
    public static final String WALKING_SPEED_MULTIPLIER = "Walking Speed Multiplier";

    public SprintAssistModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 4));
        this.addSimpleTradeoff(this, "Power", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 10.0, SPRINT_SPEED_MULTIPLIER, "%", 1.0, 2.0);
        this.addSimpleTradeoff(this, "Compensation", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 2.0, SPRINT_FOOD_COMPENSATION, "%", 0.0, 1.0);
        this.addSimpleTradeoff(this, "Walking Assist", WALKING_ENERGY_CONSUMPTION, "J", 0.0, 10.0, WALKING_SPEED_MULTIPLIER, "%", 1.0, 1.0);
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_SPRINT_ASSIST;
    }

    @Override
    public String getDescription() {
        return "A set of servo motors to help you sprint (double-tap forward) and walk faster.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double horzMovement = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (player.func_70051_ag()) {
            double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
            double sprintCost = ModuleManager.computeModularProperty(item, SPRINT_ENERGY_CONSUMPTION);
            if (sprintCost < totalEnergy) {
                double sprintMultiplier = ModuleManager.computeModularProperty(item, SPRINT_SPEED_MULTIPLIER);
                double exhaustionComp = ModuleManager.computeModularProperty(item, SPRINT_FOOD_COMPENSATION);
                ElectricItemUtils.drainPlayerEnergy(player, sprintCost * horzMovement * 5.0);
                player.field_70746_aG = (float)((double)player.field_70746_aG * sprintMultiplier);
                player.func_71024_bL().func_75113_a((float)(-0.01 * exhaustion * exhaustionComp));
                player.field_70747_aH = player.field_70746_aG * 0.5f;
            }
        } else {
            double cost = ModuleManager.computeModularProperty(item, WALKING_ENERGY_CONSUMPTION);
            if (cost < totalEnergy) {
                double walkMultiplier = ModuleManager.computeModularProperty(item, WALKING_SPEED_MULTIPLIER);
                ElectricItemUtils.drainPlayerEnergy(player, cost * horzMovement * 5.0);
                player.field_70746_aG = (float)((double)player.field_70746_aG * walkMultiplier);
                player.field_70747_aH = player.field_70746_aG * 0.5f;
            }
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "sprintassist";
    }
}

