/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_AXE = "Axe";
    public static final ItemStack ironAxe = new ItemStack(Item.field_77708_h);
    public static final String AXE_ENERGY_CONSUMPTION = "Axe Energy Consumption";
    public static final String AXE_HARVEST_SPEED = "Axe Harvest Speed";
    public static final String AXE_SEARCH_RADIUS = "Axe Search Radius";

    public AxeModule(List validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.field_77703_o, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(AXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(AXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", AXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", AXE_HARVEST_SPEED, 22.0);
        this.addTradeoffProperty("Radius", AXE_ENERGY_CONSUMPTION, 1000.0);
        this.addTradeoffProperty("Radius", AXE_SEARCH_RADIUS, 3.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return MODULE_AXE;
    }

    @Override
    public String getDescription() {
        return "Axes are mostly for chopping trees.";
    }

    @Override
    public String getTextureFile() {
        return "toolaxe";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return (ironAxe.func_77987_b(block) || ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)ironAxe)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, int blockID, int x, int y, int z, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            boolean found = true;
            double radius = ModuleManager.computeModularProperty(stack, AXE_SEARCH_RADIUS);
            int minx = (int)Math.floor((double)x - radius);
            int maxx = (int)Math.ceil((double)x + radius);
            int minz = (int)Math.floor((double)z - radius);
            int maxz = (int)Math.ceil((double)z + radius);
            while (found) {
                int newminz;
                int newminx;
                ++y;
                found = false;
                int newmaxx = newminx = (minx + maxx) / 2;
                int newmaxz = newminz = (minz + maxz) / 2;
                for (int i = minx; i < maxx; ++i) {
                    for (int j = minz; j < maxz; ++j) {
                        int id = world.func_72798_a(i, y, j);
                        if (!(Block.field_71973_m[id] instanceof BlockLog)) continue;
                        found = true;
                        newminx = (int)Math.min((double)newminx, (double)i - radius);
                        newmaxx = (int)Math.max((double)newmaxx, (double)i + radius);
                        newminz = (int)Math.min((double)newminz, (double)j - radius);
                        newmaxz = (int)Math.max((double)newmaxz, (double)j + radius);
                        playerMP.field_71134_c.func_73084_b(i, y, j);
                        ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION));
                    }
                }
                minx = newminx;
                maxx = newmaxx;
                minz = newminz;
                maxz = newmaxz;
            }
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), AXE_HARVEST_SPEED));
    }
}

