/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.PickaxeModule;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DiamondPickUpgradeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_DIAMOND_PICK_UPGRADE = "Diamond Drill Upgrade";
    public static final ItemStack diamondPick = new ItemStack(Item.field_77674_B);

    public DiamondPickUpgradeModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addInstallCost(new ItemStack(Item.field_77702_n, 3));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getName() {
        return MODULE_DIAMOND_PICK_UPGRADE;
    }

    @Override
    public String getDescription() {
        return "Add diamonds to allow your pickaxe module to mine Obsidian. *REQUIRES PICKAXE MODULE TO WORK*";
    }

    @Override
    public String getTextureFile() {
        return "diamondupgrade1";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return !PickaxeModule.ironPickaxe.func_77987_b(block) && !ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)PickaxeModule.ironPickaxe) && (diamondPick.func_77987_b(block) || ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)diamondPick)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption");
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, int blockID, int x, int y, int z, EntityPlayer player) {
        Block block = Block.field_71973_m[blockID];
        if (!PickaxeModule.ironPickaxe.func_77987_b(block)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, "Pickaxe Energy Consumption"));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), "Pickaxe Harvest Speed");
    }
}

