/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BladeLauncherModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String BLADE_ENERGY = "Spinning Blade Energy Consumption";
    public static final String BLADE_DAMAGE = "Spinning Blade Damage";

    public BladeLauncherModule(List validItems) {
        super(validItems);
        this.addBaseProperty(BLADE_ENERGY, 500.0, "J");
        this.addBaseProperty(BLADE_DAMAGE, 6.0, "pt");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.mvcapacitor, 1));
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getName() {
        return "Blade Launcher";
    }

    @Override
    public String getDescription() {
        return "Launches a spinning blade of death (or shearing).";
    }

    @Override
    public String getTextureFile() {
        return "spinningblade";
    }

    @Override
    public void onRightClick(EntityPlayer player, World world, ItemStack item) {
        if (ElectricItemUtils.getPlayerEnergy(player) > 500.0) {
            player.func_71008_a(item, 72000);
        }
    }

    @Override
    public void onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
        if (!world.field_72995_K) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, BLADE_ENERGY);
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                EntitySpinningBlade blade = new EntitySpinningBlade(world, (EntityLiving)player);
                world.func_72838_d((Entity)blade);
            }
        }
    }
}

