/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.gui.EnergyMeter;
import net.machinemuse.general.gui.HeatMeter;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.event.ThaumRenderEventHandler;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.GlowBuffer;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeHooks;

public class RenderTickHandler
implements ITickHandler {
    private static final int SWAPTIME = 200;
    public static long lastSwapTime = 0L;
    public static int lastSwapDirection = 0;
    protected static HeatMeter heat;
    protected static HeatMeter energy;
    private int lightningCounter = 0;

    public void tickStart(EnumSet type, Object ... tickData) {
        if (Config.canUseShaders) {
            GlowBuffer.clear();
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && MuseItemUtils.modularItemsEquipped((EntityPlayer)player).size() > 0 && Minecraft.func_71410_x().field_71462_r == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution screen = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            this.drawMeters((EntityPlayer)player, screen);
            this.drawGogglesHUD((EntityPlayer)player, mc, ((Float)tickData[0]).floatValue());
            this.drawActiveMode((EntityPlayer)player, screen);
        }
    }

    private void drawMeters(EntityPlayer player, ScaledResolution screen) {
        double currEnergy = ElectricItemUtils.getPlayerEnergy(player);
        double maxEnergy = ElectricItemUtils.getMaxEnergy(player);
        double currHeat = MuseHeatUtils.getPlayerHeat(player);
        double maxHeat = MuseHeatUtils.getMaxHeat(player);
        if (maxEnergy > 0.0 && BlockTinkerTable.energyIcon != null) {
            String currStr = MuseStringUtils.formatNumberShort(currEnergy);
            String maxStr = MuseStringUtils.formatNumberShort(maxEnergy);
            String currHeatStr = MuseStringUtils.formatNumberShort(currHeat);
            String maxHeatStr = MuseStringUtils.formatNumberShort(maxHeat);
            if (Config.useGraphicalMeters()) {
                if (energy == null) {
                    energy = new EnergyMeter();
                    heat = new HeatMeter();
                }
                double left = screen.func_78326_a() - 20;
                double top = (double)screen.func_78328_b() / 2.0 - 16.0;
                energy.draw(left, top, currEnergy / maxEnergy);
                heat.draw(left + 8.0, top, currHeat / maxHeat);
                MuseRenderer.drawRightAlignedString(currStr, left - 2.0, top + 10.0);
                MuseRenderer.drawRightAlignedString(currHeatStr, left - 2.0, top + 20.0);
            } else {
                MuseRenderer.drawString(currStr + '/' + maxStr + " \u1d60", 1.0, 1.0);
                MuseRenderer.drawString(currHeatStr + '/' + maxHeatStr + " C", 1.0, 10.0);
            }
        }
    }

    private void drawActiveMode(EntityPlayer player, ScaledResolution screen) {
        int i = player.field_71071_by.field_70461_c;
        ItemStack stack = player.field_71071_by.field_70462_a[i];
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            MuseRenderer.pushTexture("/gui/items.png");
            MuseRenderer.blendingOn();
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            int swapTime = (int)Math.min(System.currentTimeMillis() - lastSwapTime, 200L);
            Icon currentMode = null;
            Icon nextMode = null;
            Icon prevMode = null;
            List modes = MuseItemUtils.getModes(stack, player);
            String mode = itemTag.func_74779_i("Mode");
            int modeIndex = modes.indexOf(mode);
            if (modeIndex > -1) {
                String prevModeName = (String)modes.get((modeIndex + modes.size() - 1) % modes.size());
                String nextModeName = (String)modes.get((modeIndex + 1) % modes.size());
                IPowerModule module = ModuleManager.getModule(mode);
                IPowerModule nextModule = ModuleManager.getModule(nextModeName);
                IPowerModule prevModule = ModuleManager.getModule(prevModeName);
                if (module != null) {
                    currentMode = module.getIcon(stack);
                    if (!nextModeName.equals(mode)) {
                        nextMode = nextModule.getIcon(stack);
                        prevMode = prevModule.getIcon(stack);
                    }
                }
            }
            int sw = screen.func_78326_a();
            int sh = screen.func_78328_b();
            int baroffset = 22;
            if (!player.field_71075_bZ.field_75098_d) {
                baroffset += 16;
                if (ForgeHooks.getTotalArmorValue((EntityPlayer)player) > 0) {
                    baroffset += 8;
                }
            }
            MuseRenderer.scissorsOn(0.0, 0.0, sw, sh - baroffset);
            baroffset = screen.func_78328_b() - baroffset;
            double prevX = (double)sw / 2.0 - 105.0 + 20.0 * (double)i;
            double prevY = baroffset - 8;
            double currX = (double)sw / 2.0 - 89.0 + 20.0 * (double)i;
            double currY = baroffset - 18;
            double nextX = (double)sw / 2.0 - 73.0 + 20.0 * (double)i;
            double nextY = baroffset - 8;
            if (swapTime == 200 || lastSwapDirection == 0) {
                this.drawIcon(prevX, prevY, prevMode, 0.4);
                this.drawIcon(currX, currY, currentMode, 0.8);
                this.drawIcon(nextX, nextY, nextMode, 0.4);
            } else {
                double r1 = 1.0 - (double)swapTime / 200.0;
                double r2 = (double)swapTime / 200.0;
                if (lastSwapDirection == -1) {
                    nextX = currX * r1 + nextX * r2;
                    nextY = currY * r1 + nextY * r2;
                    currX = prevX * r1 + currX * r2;
                    currY = prevY * r1 + currY * r2;
                    this.drawIcon(currX, currY, currentMode, 0.8);
                    this.drawIcon(nextX, nextY, nextMode, 0.8);
                } else {
                    prevX = currX * r1 + prevX * r2;
                    prevY = currY * r1 + prevY * r2;
                    currX = nextX * r1 + currX * r2;
                    currY = nextY * r1 + currY * r2;
                    this.drawIcon(prevX, prevY, prevMode, 0.8);
                    this.drawIcon(currX, currY, currentMode, 0.8);
                }
            }
            MuseRenderer.scissorsOff();
            MuseRenderer.blendingOff();
            Colour.WHITE.doGL();
            MuseRenderer.popTexture();
        }
    }

    private void drawGogglesHUD(EntityPlayer player, Minecraft mc, float partialTickTime) {
        if (ModCompatability.isThaumCraftLoaded() && ModCompatability.enableThaumGogglesModule() && player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() instanceof IModularItem && MuseItemUtils.itemHasActiveModule(player.func_82169_q(3), "Aurameter")) {
            ThaumRenderEventHandler.renderGogglesHUD(partialTickTime, player, mc.field_71441_e.func_72820_D());
        }
    }

    private void drawIcon(double x, double y, Icon icon, double alpha) {
        MuseRenderer.drawIconAt(x, y, icon, Colour.WHITE.withAlpha(alpha));
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.RENDER);
    }

    public String getLabel() {
        return "MMMPS: Render Tick";
    }
}

