/*
 * Decompiled with CFR 0.152.
 */
package mffs;

import cpw.mods.fml.common.Loader;
import java.io.File;
import mffs.ModularForceFieldSystem;
import mffs.api.Blacklist;
import net.minecraft.block.Block;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class Settings {
    public static final Configuration CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "Modular Force Field System.cfg"));
    public static final int BLOCK_ID_PREFIX = 1680;
    public static final int ITEM_ID_PREFIX = 11130;
    private static int NEXT_BLOCK_ID = 1680;
    private static int NEXT_ITEM_ID = 11130;
    public static int MAX_FORCE_FIELDS_PER_TICK = 1000;
    public static int MAX_FORCE_FIELD_SCALE = 200;
    public static boolean INTERACT_CREATIVE = true;
    public static boolean LOAD_CHUNKS = true;
    public static boolean OP_OVERRIDE = true;
    public static boolean USE_CACHE = true;
    public static boolean ENABLE_ELECTRICITY = true;
    public static boolean CONSERVE_PACKETS = true;
    public static boolean HIGH_GRAPHICS = true;
    public static int INTERDICTION_MURDER_ENERGY = 0;
    public static final int MAX_FREQUENCY_DIGITS = 6;
    public static boolean ENABLE_MANIPULATOR = true;

    public static int getNextBlockID() {
        return ++NEXT_BLOCK_ID;
    }

    public static int getNextItemID() {
        return ++NEXT_ITEM_ID;
    }

    public static void load() {
        Property blacklist1;
        String blackListString1;
        CONFIGURATION.load();
        ENABLE_MANIPULATOR = CONFIGURATION.get("general", "Enable Force Manipulator", ENABLE_MANIPULATOR).getBoolean(ENABLE_MANIPULATOR);
        Property propFieldScale = CONFIGURATION.get("general", "Max Force Field Scale", MAX_FORCE_FIELD_SCALE);
        MAX_FORCE_FIELD_SCALE = propFieldScale.getInt(MAX_FORCE_FIELD_SCALE);
        Property propInterdiction = CONFIGURATION.get("general", "Interdiction Murder Fortron Consumption", INTERDICTION_MURDER_ENERGY);
        INTERDICTION_MURDER_ENERGY = propInterdiction.getInt(INTERDICTION_MURDER_ENERGY);
        Property propCreative = CONFIGURATION.get("general", "Effect Creative Players", INTERACT_CREATIVE);
        propCreative.comment = "Should the interdiction matrix interact with creative players?.";
        INTERACT_CREATIVE = propCreative.getBoolean(INTERACT_CREATIVE);
        Property propChunkLoading = CONFIGURATION.get("general", "Load Chunks", LOAD_CHUNKS);
        propChunkLoading.comment = "Set this to false to turn off the MFFS Chunkloading capabilities.";
        LOAD_CHUNKS = propChunkLoading.getBoolean(LOAD_CHUNKS);
        Property propOpOverride = CONFIGURATION.get("general", "Op Override", OP_OVERRIDE);
        propOpOverride.comment = "Allow the operator(s) to override security measures created by MFFS?";
        OP_OVERRIDE = propOpOverride.getBoolean(OP_OVERRIDE);
        Property propUseCache = CONFIGURATION.get("general", "Use Cache", USE_CACHE);
        propUseCache.comment = "Cache allows temporary data saving to decrease calculations required.";
        USE_CACHE = propUseCache.getBoolean(USE_CACHE);
        Property maxFFGenPerTick = CONFIGURATION.get("general", "Field Calculation Per Tick", MAX_FORCE_FIELDS_PER_TICK);
        maxFFGenPerTick.comment = "How many force field blocks can be generated per tick? Less reduces lag.";
        MAX_FORCE_FIELDS_PER_TICK = maxFFGenPerTick.getInt(MAX_FORCE_FIELDS_PER_TICK);
        Property useElectricity = CONFIGURATION.get("general", "Require Electricity?", ENABLE_ELECTRICITY);
        useElectricity.comment = "Turning this to false will make MFFS run without electricity or energy systems required. Great for vanilla!";
        ENABLE_ELECTRICITY = useElectricity.getBoolean(ENABLE_ELECTRICITY);
        Property conservePackets = CONFIGURATION.get("general", "Conserve Packets?", CONSERVE_PACKETS);
        conservePackets.comment = "Turning this to false will enable better client side packet and updates but in the cost of more packets sent.";
        CONSERVE_PACKETS = conservePackets.getBoolean(CONSERVE_PACKETS);
        Property highGraphics = CONFIGURATION.get("general", "High Graphics", HIGH_GRAPHICS);
        highGraphics.comment = "Turning this to false will reduce rendering and client side packet graphical packets.";
        CONSERVE_PACKETS = highGraphics.getBoolean(HIGH_GRAPHICS);
        Property forceManipulatorBlacklist = CONFIGURATION.get("general", "Force Manipulator Blacklist", "");
        highGraphics.comment = "Put a list of block IDs to be not-moved by the force manipulator. Separate by commas, no space.";
        String blackListString = forceManipulatorBlacklist.getString();
        if (blackListString != null) {
            for (String blockIDString : blackListString.split(",")) {
                if (blockIDString == null || blockIDString.isEmpty()) continue;
                try {
                    int blockID = Integer.parseInt(blockIDString);
                    Blacklist.forceManipulationBlacklist.add(Block.field_71973_m[blockID]);
                }
                catch (Exception e) {
                    ModularForceFieldSystem.LOGGER.severe("Invalid block blacklist ID!");
                    e.printStackTrace();
                }
            }
        }
        if ((blackListString1 = (blacklist1 = CONFIGURATION.get("general", "Stabilization Blacklist", "")).getString()) != null) {
            for (String blockIDString : blackListString1.split(",")) {
                if (blockIDString == null || blockIDString.isEmpty()) continue;
                try {
                    int blockID = Integer.parseInt(blockIDString);
                    Blacklist.stabilizationBlacklist.add(Block.field_71973_m[blockID]);
                }
                catch (Exception e) {
                    ModularForceFieldSystem.LOGGER.severe("Invalid block blacklist ID!");
                    e.printStackTrace();
                }
            }
        }
        Property blacklist2 = CONFIGURATION.get("general", "Disintegration Blacklist", "");
        String blackListString2 = blacklist1.getString();
        if (blackListString2 != null) {
            for (String blockIDString : blackListString2.split(",")) {
                if (blockIDString == null || blockIDString.isEmpty()) continue;
                try {
                    int blockID = Integer.parseInt(blockIDString);
                    Blacklist.disintegrationBlacklist.add(Block.field_71973_m[blockID]);
                }
                catch (Exception e) {
                    ModularForceFieldSystem.LOGGER.severe("Invalid block blacklist ID!");
                    e.printStackTrace();
                }
            }
        }
        Blacklist.stabilizationBlacklist.add(Block.field_71943_B);
        Blacklist.stabilizationBlacklist.add(Block.field_71942_A);
        Blacklist.stabilizationBlacklist.add(Block.field_71938_D);
        Blacklist.stabilizationBlacklist.add(Block.field_71944_C);
        Blacklist.disintegrationBlacklist.add(Block.field_71943_B);
        Blacklist.disintegrationBlacklist.add(Block.field_71942_A);
        Blacklist.disintegrationBlacklist.add(Block.field_71938_D);
        Blacklist.stabilizationBlacklist.add(Block.field_71944_C);
        Blacklist.forceManipulationBlacklist.add(Block.field_71986_z);
        Blacklist.forceManipulationBlacklist.add(ModularForceFieldSystem.blockForceField);
        CONFIGURATION.save();
    }
}

