/*
 * Decompiled with CFR 0.152.
 */
package mffs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mffs.MFFSHelper;
import mffs.ModularForceFieldSystem;
import mffs.api.security.IInterdictionMatrix;
import mffs.api.security.Permission;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.liquids.LiquidDictionary;
import universalelectricity.core.vector.Vector3;

public class SubscribeEventHandler {
    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            LiquidDictionary.getCanonicalLiquid((String)"Fortron").setRenderingIcon(ModularForceFieldSystem.itemFortron.func_77617_a(0)).setTextureSheet("/gui/items.png");
        }
    }

    @ForgeSubscribe
    public void playerInteractEvent(PlayerInteractEvent evt) {
        if (evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || evt.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            if (evt.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && evt.entityPlayer.field_70170_p.func_72798_a(evt.x, evt.y, evt.z) == ModularForceFieldSystem.blockForceField.field_71990_ca) {
                evt.setCanceled(true);
                return;
            }
            if (evt.entityPlayer.field_71075_bZ.field_75098_d) {
                return;
            }
            Vector3 position = new Vector3(evt.x, evt.y, evt.z);
            IInterdictionMatrix interdictionMatrix = MFFSHelper.getNearestInterdictionMatrix(evt.entityPlayer.field_70170_p, position);
            if (interdictionMatrix != null) {
                int blockID = position.getBlockID((IBlockAccess)evt.entityPlayer.field_70170_p);
                if (ModularForceFieldSystem.blockBiometricIdentifier.field_71990_ca == blockID && MFFSHelper.isPermittedByInterdictionMatrix(interdictionMatrix, evt.entityPlayer.field_71092_bJ, Permission.SECURITY_CENTER_CONFIGURE)) {
                    return;
                }
                boolean hasPermission = MFFSHelper.hasPermission(evt.entityPlayer.field_70170_p, new Vector3(evt.x, evt.y, evt.z), interdictionMatrix, evt.action, evt.entityPlayer);
                if (!hasPermission) {
                    evt.entityPlayer.func_70006_a("[" + ModularForceFieldSystem.blockInterdictionMatrix.func_71931_t() + "] You have no permission to do that!");
                    evt.setCanceled(true);
                }
            }
        }
    }

    @ForgeSubscribe
    public void livingSpawnEvent(LivingSpawnEvent evt) {
        IInterdictionMatrix interdictionMatrix = MFFSHelper.getNearestInterdictionMatrix(evt.world, new Vector3((Entity)evt.entityLiving));
        if (interdictionMatrix != null && interdictionMatrix.getModuleCount(ModularForceFieldSystem.itemModuleAntiSpawn, new int[0]) > 0) {
            evt.setResult(Event.Result.DENY);
        }
    }
}

