/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import dan200.computer.api.IPeripheral;
import java.io.IOException;
import java.lang.constant.Constable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import mffs.ModularForceFieldSystem;
import mffs.api.IActivatable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.prefab.implement.IRedstoneReceptor;
import universalelectricity.prefab.implement.IRotatable;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityDisableable;

public abstract class TileEntityBase
extends TileEntityDisableable
implements IPacketReceiver,
IRotatable,
IRedstoneReceptor,
IActivatable,
IPeripheral {
    private boolean isActive = false;
    private boolean isRedstoneActive = false;
    public final List playersUsing = new ArrayList();
    public float animation = 0.0f;

    public List getPacketUpdate() {
        ArrayList<Constable> objects = new ArrayList<Constable>();
        objects.add(Integer.valueOf(TilePacketType.DESCRIPTION.ordinal()));
        objects.add(Boolean.valueOf(this.isActive));
        return objects;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.ticks % 4L == 0L && this.playersUsing.size() > 0) {
            for (EntityPlayer player : this.playersUsing) {
                PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)player));
            }
        }
    }

    public Packet func_70319_e() {
        return PacketManager.getPacket("MFFS", this, this.getPacketUpdate().toArray());
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.onReceivePacket(dataStream.readInt(), dataStream);
        }
        catch (Exception e) {
            ModularForceFieldSystem.LOGGER.severe(MessageFormat.format("Packet receiving failed: {0}", this.getClass().getSimpleName()));
            e.printStackTrace();
        }
    }

    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        if (packetID == TilePacketType.DESCRIPTION.ordinal()) {
            boolean prevActive = this.isActive;
            this.isActive = dataStream.readBoolean();
            if (prevActive != this.isActive) {
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else if (packetID == TilePacketType.TOGGLE_ACTIVATION.ordinal()) {
            boolean bl = this.isRedstoneActive = !this.isRedstoneActive;
            if (this.isRedstoneActive) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean isPoweredByRedstone() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isActive = nbttagcompound.func_74767_n("isActive");
        this.isRedstoneActive = nbttagcompound.func_74767_n("isRedstoneActive");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("isActive", this.isActive);
        nbttagcompound.func_74757_a("isRedstoneActive", this.isRedstoneActive);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean flag) {
        this.isActive = flag;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ForgeDirection getDirection(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)this.func_70322_n());
    }

    @Override
    public void setDirection(World world, int x, int y, int z, ForgeDirection facingDirection) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, facingDirection.ordinal(), 3);
    }

    @Override
    public void onPowerOn() {
        this.setActive(true);
    }

    @Override
    public void onPowerOff() {
        if (!this.isRedstoneActive && !this.field_70331_k.field_72995_K) {
            this.setActive(false);
        }
    }

    public static enum TilePacketType {
        NONE,
        DESCRIPTION,
        FREQUENCY,
        TOGGLE_ACTIVATION,
        TOGGLE_MODE,
        INVENTORY,
        STRING,
        FXS,
        TOGGLE_MODE_2,
        TOGGLE_MODE_3;

    }
}

