/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mffs.base.TileEntityBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.multiblock.TileEntityMulti;
import universalelectricity.prefab.network.PacketManager;

public abstract class TileEntityInventory
extends TileEntityBase
implements IInventory {
    protected ItemStack[] inventory = new ItemStack[this.func_70302_i_()];

    @Override
    public List getPacketUpdate() {
        ArrayList<NBTTagCompound> objects = new ArrayList<NBTTagCompound>();
        objects.addAll(super.getPacketUpdate());
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        objects.add(nbt);
        return objects;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (this.field_70331_k.field_72995_K && (packetID == TileEntityBase.TilePacketType.DESCRIPTION.ordinal() || packetID == TileEntityBase.TilePacketType.INVENTORY.ordinal())) {
            this.func_70307_a(PacketManager.readNBTTagCompound(dataStream));
        }
    }

    public void sendInventoryToClients() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        PacketManager.sendPacketToClients(PacketManager.getPacket("MFFS", this, new Object[]{TileEntityBase.TilePacketType.INVENTORY.ordinal(), nbt}));
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public String func_70303_b() {
        return this.func_70311_o().func_71931_t();
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public ItemStack func_70304_b(int slotID) {
        if (this.inventory[slotID] != null) {
            ItemStack itemstack = this.inventory[slotID];
            this.inventory[slotID] = null;
            return itemstack;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return true;
    }

    public boolean canIncreaseStack(int slotID, ItemStack itemStack) {
        if (this.func_70301_a(slotID) == null) {
            return true;
        }
        if (this.func_70301_a((int)slotID).field_77994_a + 1 <= 64) {
            return this.func_70301_a(slotID).func_77969_a(itemStack);
        }
        return false;
    }

    public void incrStackSize(int slot, ItemStack itemStack) {
        if (this.func_70301_a(slot) == null) {
            this.func_70299_a(slot, itemStack.func_77946_l());
        } else if (this.func_70301_a(slot).func_77969_a(itemStack)) {
            ++this.func_70301_a((int)slot).field_77994_a;
        }
    }

    public Set getCards() {
        HashSet<ItemStack> cards = new HashSet<ItemStack>();
        cards.add(this.func_70301_a(0));
        return cards;
    }

    public ItemStack tryPlaceInPosition(ItemStack itemStack, Vector3 position, ForgeDirection dir) {
        TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_70331_k);
        ForgeDirection direction = dir.getOpposite();
        if (tileEntity != null && itemStack != null) {
            if (tileEntity instanceof TileEntityMulti) {
                Vector3 mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition;
                if (mainBlockPosition != null && !(mainBlockPosition.getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileEntityMulti)) {
                    return this.tryPlaceInPosition(itemStack, mainBlockPosition, direction);
                }
            } else if (tileEntity instanceof TileEntityChest) {
                TileEntityChest[] chests = new TileEntityChest[]{(TileEntityChest)tileEntity, null};
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection searchDirection = ForgeDirection.getOrientation((int)i);
                    Vector3 searchPosition = position.clone();
                    searchPosition.modifyPositionFromSide(searchDirection);
                    if (searchPosition.getTileEntity((IBlockAccess)this.field_70331_k) == null || searchPosition.getTileEntity((IBlockAccess)this.field_70331_k).getClass() != chests[0].getClass()) continue;
                    chests[1] = (TileEntityChest)searchPosition.getTileEntity((IBlockAccess)this.field_70331_k);
                    break;
                }
                for (TileEntityChest chest : chests) {
                    if (chest == null) continue;
                    for (int i = 0; i < chest.func_70302_i_(); ++i) {
                        if ((itemStack = this.addStackToInventory(i, (IInventory)chest, itemStack)) != null) continue;
                        return null;
                    }
                }
            } else if (tileEntity instanceof ISidedInventory) {
                ISidedInventory inventory = (ISidedInventory)tileEntity;
                int[] slots = inventory.func_94128_d(direction.ordinal());
                for (int i = 0; i < slots.length; ++i) {
                    if (inventory.func_102007_a(slots[i], itemStack, direction.ordinal())) {
                        itemStack = this.addStackToInventory(slots[i], (IInventory)inventory, itemStack);
                    }
                    if (itemStack != null) continue;
                    return null;
                }
            } else if (tileEntity instanceof IInventory) {
                IInventory inventory = (IInventory)tileEntity;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if ((itemStack = this.addStackToInventory(i, inventory, itemStack)) != null) continue;
                    return null;
                }
            }
        }
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack addStackToInventory(int slotIndex, IInventory inventory, ItemStack itemStack) {
        if (inventory.func_70302_i_() > slotIndex) {
            ItemStack stackInInventory = inventory.func_70301_a(slotIndex);
            if (stackInInventory == null) {
                inventory.func_70299_a(slotIndex, itemStack);
                if (inventory.func_70301_a(slotIndex) == null) {
                    return itemStack;
                }
                return null;
            }
            if (stackInInventory.func_77969_a(itemStack) && stackInInventory.func_77985_e()) {
                stackInInventory = stackInInventory.func_77946_l();
                int stackLim = Math.min(inventory.func_70297_j_(), itemStack.func_77976_d());
                int rejectedAmount = Math.max(stackInInventory.field_77994_a + itemStack.field_77994_a - stackLim, 0);
                stackInInventory.field_77994_a = Math.min(Math.max(stackInInventory.field_77994_a + itemStack.field_77994_a - rejectedAmount, 0), inventory.func_70297_j_());
                itemStack.field_77994_a = rejectedAmount;
                inventory.func_70299_a(slotIndex, stackInInventory);
            }
        }
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public boolean mergeIntoInventory(ItemStack itemStack) {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (itemStack == null) continue;
                itemStack = this.tryPlaceInPosition(itemStack, new Vector3(this).modifyPositionFromSide(direction), direction);
            }
            if (itemStack != null) {
                this.field_70331_k.func_72838_d((Entity)new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.5, itemStack));
            }
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        NBTTagList nbtTagList = nbttagcompound.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbtTagList.func_74743_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbtTagList.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbtTagList);
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"isActivate", "setActivate"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.isActive()};
            }
            case 1: {
                this.setActive((Boolean)arguments[0]);
                return null;
            }
        }
        throw new Exception("Invalid method.");
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }
}

