/*
 * Decompiled with CFR 0.152.
 */
package mffs.fortron;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import icbm.api.IBlockFrequency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mffs.api.fortron.IFortronFrequency;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

public class FrequencyGrid {
    private static FrequencyGrid CLIENT_INSTANCE = new FrequencyGrid();
    private static FrequencyGrid SERVER_INSTANCE = new FrequencyGrid();
    private final Set frequencyGrid = new HashSet();

    public void register(IBlockFrequency tileEntity) {
        try {
            Iterator it = this.frequencyGrid.iterator();
            while (it.hasNext()) {
                IBlockFrequency frequency = (IBlockFrequency)it.next();
                if (frequency == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)frequency).func_70320_p()) {
                    it.remove();
                    continue;
                }
                if (!new Vector3((TileEntity)frequency).equals(new Vector3((TileEntity)tileEntity))) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frequencyGrid.add(tileEntity);
    }

    public void unregister(IBlockFrequency tileEntity) {
        this.frequencyGrid.remove(tileEntity);
        this.cleanUp();
    }

    public Set get() {
        return this.frequencyGrid;
    }

    public Set get(int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tile : this.get()) {
            if (tile == null || ((TileEntity)tile).func_70320_p() || tile.getFrequency() != frequency) continue;
            set.add(tile);
        }
        return set;
    }

    public void cleanUp() {
        try {
            Iterator it = this.frequencyGrid.iterator();
            while (it.hasNext()) {
                IBlockFrequency frequency = (IBlockFrequency)it.next();
                if (frequency == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)frequency).func_70320_p()) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)frequency).field_70331_k.func_72796_p(((TileEntity)frequency).field_70329_l, ((TileEntity)frequency).field_70330_m, ((TileEntity)frequency).field_70327_n) == (TileEntity)frequency) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set get(World world, Vector3 position, int radius, int frequency) {
        HashSet<IBlockFrequency> set = new HashSet<IBlockFrequency>();
        for (IBlockFrequency tileEntity : this.get(frequency)) {
            if (((TileEntity)tileEntity).field_70331_k != world) continue;
            Vector3 vector3 = new Vector3((TileEntity)tileEntity);
            if (!(Vector3.distance(vector3, position) <= (double)radius)) continue;
            set.add(tileEntity);
        }
        return set;
    }

    public Set getFortronTiles(World world, Vector3 position, int radius, int frequency) {
        HashSet<IFortronFrequency> set = new HashSet<IFortronFrequency>();
        for (IBlockFrequency tileEntity : this.get(frequency)) {
            if (((TileEntity)tileEntity).field_70331_k != world || !(tileEntity instanceof IFortronFrequency)) continue;
            Vector3 vector3 = new Vector3((TileEntity)tileEntity);
            if (!(Vector3.distance(vector3, position) <= (double)radius)) continue;
            set.add((IFortronFrequency)tileEntity);
        }
        return set;
    }

    public static void reinitiate() {
        CLIENT_INSTANCE = new FrequencyGrid();
        SERVER_INSTANCE = new FrequencyGrid();
    }

    public static FrequencyGrid instance() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return SERVER_INSTANCE;
        }
        return CLIENT_INSTANCE;
    }
}

