/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.module.projector;

import calclavia.lib.CalculationHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mffs.api.IFieldInteraction;
import mffs.api.IProjector;
import mffs.item.mode.ItemMode;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region3;

public class ItemModePyramid
extends ItemMode {
    public ItemModePyramid(int i) {
        super(i, "modePyramid");
    }

    @Override
    public Set getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        int xStretch = posScale.intX() + negScale.intX();
        int yStretch = posScale.intY() + negScale.intY();
        int zStretch = posScale.intZ() + negScale.intZ();
        Vector3 translation = new Vector3(0.0, -negScale.intY(), 0.0);
        int inverseThickness = 8;
        for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
            for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
                for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                    double yTest = y / (float)yStretch * 8.0f;
                    double xzPositivePlane = (1.0f - x / (float)xStretch - z / (float)zStretch) * 8.0f;
                    double xzNegativePlane = (1.0f + x / (float)xStretch - z / (float)zStretch) * 8.0f;
                    if (x >= 0.0f && z >= 0.0f && Math.round(xzPositivePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vector3(x, y, z).add(translation));
                        fieldBlocks.add(new Vector3(x, y, -z).add(translation));
                    }
                    if (x <= 0.0f && z >= 0.0f && Math.round(xzNegativePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vector3(x, y, -z).add(translation));
                        fieldBlocks.add(new Vector3(x, y, z).add(translation));
                    }
                    if (y != 0.0f || !(Math.abs(x) + Math.abs(z) < (float)((xStretch + yStretch) / 2))) continue;
                    fieldBlocks.add(new Vector3(x, y, z).add(translation));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        int xStretch = posScale.intX() + negScale.intX();
        int yStretch = posScale.intY() + negScale.intY();
        int zStretch = posScale.intZ() + negScale.intZ();
        Vector3 translation = new Vector3(0.0, -0.4, 0.0);
        for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
            for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
                    Vector3 position = new Vector3(x, y, z).add(translation);
                    if (!this.isInField(projector, Vector3.add(position, new Vector3((TileEntity)projector)))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3 position) {
        Vector3 posScale = projector.getPositiveScale().clone();
        Vector3 negScale = projector.getNegativeScale().clone();
        int xStretch = posScale.intX() + negScale.intX();
        int yStretch = posScale.intY() + negScale.intY();
        int zStretch = posScale.intZ() + negScale.intZ();
        Vector3 projectorPos = new Vector3((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        projectorPos.add(new Vector3(0.0, -negScale.intY() + 1, 0.0));
        Vector3 relativePosition = position.clone().subtract(projectorPos);
        CalculationHelper.rotateByAngle(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch());
        Region3 region = new Region3(negScale.multiply(-1.0), posScale);
        return region.isIn(relativePosition) && relativePosition.y > 0.0 && 1.0 - Math.abs(relativePosition.x) / (double)xStretch - Math.abs(relativePosition.z) / (double)zStretch > relativePosition.y / (double)yStretch;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float height = 0.5f;
        float width = 0.3f;
        int uvMaxX = 2;
        int uvMaxY = 2;
        Vector3 translation = new Vector3(0.0, -0.4, 0.0);
        tessellator.func_78371_b(6);
        tessellator.func_78370_a(72, 198, 255, 255);
        tessellator.func_78374_a(0.0 + translation.x, 0.0 + translation.y, 0.0 + translation.z, 0.0, 0.0);
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)(-uvMaxX), (double)(-uvMaxY));
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)width + translation.z, (double)(-uvMaxX), (double)uvMaxY);
        tessellator.func_78374_a((double)width + translation.x, (double)height + translation.y, (double)width + translation.z, (double)uvMaxX, (double)uvMaxY);
        tessellator.func_78374_a((double)width + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)uvMaxX, (double)(-uvMaxY));
        tessellator.func_78374_a((double)(-width) + translation.x, (double)height + translation.y, (double)(-width) + translation.z, (double)(-uvMaxX), (double)(-uvMaxY));
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }
}

