/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import java.util.HashSet;
import java.util.Set;
import mffs.tileentity.TileEntityForceManipulator;
import universalelectricity.core.vector.Vector3;

public class ManipulatorCalculationThread
extends Thread {
    private TileEntityForceManipulator manipulator;
    private IThreadCallBack callBack;

    public ManipulatorCalculationThread(TileEntityForceManipulator projector) {
        this.manipulator = projector;
    }

    public ManipulatorCalculationThread(TileEntityForceManipulator projector, IThreadCallBack callBack) {
        this(projector);
        this.callBack = callBack;
    }

    @Override
    public void run() {
        this.manipulator.isCalculatingManipulation = true;
        try {
            Set mobilizationPoints = this.manipulator.getInteriorPoints();
            if (this.manipulator.canMove()) {
                this.manipulator.manipulationVectors = new HashSet();
                for (Vector3 position : mobilizationPoints) {
                    this.manipulator.manipulationVectors.add(position.clone());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.manipulator.isCalculatingManipulation = false;
        if (this.callBack != null) {
            this.callBack.onThreadComplete();
        }
    }

    public static interface IThreadCallBack {
        public void onThreadComplete();
    }
}

