/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import mffs.MFFSHelper;
import mffs.tileentity.TileEntityForceFieldProjector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.IBlockAccess;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public class TileEntityForceField
extends TileEntityAdvanced
implements IPacketReceiver {
    private Vector3 projector = null;
    public ItemStack camoStack = null;

    public boolean canUpdate() {
        return false;
    }

    public Packet func_70319_e() {
        if (this.getProjector() != null) {
            int itemID = -1;
            int itemMetadata = -1;
            if (this.camoStack != null) {
                itemID = this.camoStack.field_77993_c;
                itemMetadata = this.camoStack.func_77960_j();
            }
            return PacketManager.getPacket("MFFS", this, new Object[]{this.projector.intX(), this.projector.intY(), this.projector.intZ(), itemID, itemMetadata});
        }
        return null;
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            this.setProjector(new Vector3(dataStream.readInt(), dataStream.readInt(), dataStream.readInt()));
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.camoStack = null;
            int itemID = dataStream.readInt();
            int itemMetadata = dataStream.readInt();
            if (itemID != -1 && itemMetadata != -1) {
                this.camoStack = new ItemStack(Block.field_71973_m[itemID], 1, itemMetadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProjector(Vector3 position) {
        this.projector = position;
        if (!this.field_70331_k.field_72995_K) {
            this.refreshCamoBlock();
        }
    }

    public TileEntityForceFieldProjector getProjector() {
        if (this.getProjectorSafe() != null) {
            return this.getProjectorSafe();
        }
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
        }
        return null;
    }

    public TileEntityForceFieldProjector getProjectorSafe() {
        if (this.projector != null && this.projector.getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileEntityForceFieldProjector && (this.field_70331_k.field_72995_K || ((TileEntityForceFieldProjector)this.projector.getTileEntity((IBlockAccess)this.field_70331_k)).getCalculatedField().contains(new Vector3(this)))) {
            return (TileEntityForceFieldProjector)this.projector.getTileEntity((IBlockAccess)this.field_70331_k);
        }
        return null;
    }

    public void refreshCamoBlock() {
        if (this.getProjectorSafe() != null) {
            this.camoStack = MFFSHelper.getCamoBlock(this.getProjector(), new Vector3(this));
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.projector = Vector3.readFromNBT(nbt.func_74775_l("projector"));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.getProjector() != null) {
            nbt.func_74766_a("projector", this.projector.writeToNBT(new NBTTagCompound()));
        }
    }
}

