/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.Blacklist;
import mffs.api.ISpecialForceManipulation;
import mffs.api.modules.IModule;
import mffs.api.modules.IProjectorMode;
import mffs.base.TileEntityBase;
import mffs.card.ItemCard;
import mffs.event.BlockPreMoveDelayedEvent;
import mffs.tileentity.ManipulatorCalculationThread;
import mffs.tileentity.TileEntityFieldInteraction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public class TileEntityForceManipulator
extends TileEntityFieldInteraction {
    public static final int ANIMATION_TIME = 20;
    public Vector3 anchor = null;
    public int displayMode = 1;
    public boolean isCalculatingManipulation = false;
    public Set manipulationVectors = null;
    public boolean doAnchor = true;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.anchor == null) {
            this.anchor = new Vector3();
        }
        if (this.getMode() != null && Settings.ENABLE_MANIPULATOR) {
            if (!this.field_70331_k.field_72995_K && this.manipulationVectors != null && !this.isCalculatingManipulation) {
                ForgeDirection dir = this.getDirection((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                NBTTagCompound nbt = new NBTTagCompound();
                NBTTagList nbtList = new NBTTagList();
                int i = 0;
                for (Vector3 position : this.manipulationVectors) {
                    if (!this.moveBlock(position, dir) || !this.isBlockVisible(position) || i >= Settings.MAX_FORCE_FIELDS_PER_TICK) continue;
                    nbtList.func_74742_a((NBTBase)position.writeToNBT(new NBTTagCompound()));
                    ++i;
                }
                nbt.func_74774_a("type", (byte)2);
                nbt.func_74782_a("list", (NBTBase)nbtList);
                PacketManager.sendPacketToClients(PacketManager.getPacket("MFFS", this, new Object[]{TileEntityBase.TilePacketType.FXS.ordinal(), nbt}), this.field_70331_k, new Vector3(this), 60.0);
                if (this.doAnchor) {
                    this.anchor = this.anchor.modifyPositionFromSide(dir);
                }
                this.updatePushedObjects(0.022f);
                this.manipulationVectors = null;
                this.func_70296_d();
            }
            if (this.isActive() && this.ticks % 20L == 0L && this.requestFortron(this.getFortronCost(), false) > 0) {
                if (!this.field_70331_k.field_72995_K) {
                    this.requestFortron(this.getFortronCost(), true);
                    new ManipulatorCalculationThread(this).start();
                }
                if (this.getModuleCount(ModularForceFieldSystem.itemModuleSilence, new int[0]) <= 0) {
                    this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "mffs.fieldmove", 0.6f, 1.0f - this.field_70331_k.field_73012_v.nextFloat() * 0.1f);
                }
                this.setActive(false);
            }
            if (!this.field_70331_k.field_72995_K) {
                if (!this.isCalculated) {
                    this.calculateForceField();
                }
                if (this.ticks % 120L == 0L && !this.isCalculating && Settings.HIGH_GRAPHICS && this.getDelayedEvents().size() <= 0 && this.displayMode > 0) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    NBTTagList nbtList = new NBTTagList();
                    int i = 0;
                    for (Vector3 position : this.getInteriorPoints()) {
                        if (!this.isBlockVisible(position) || this.displayMode != 2 && position.getBlockID((IBlockAccess)this.field_70331_k) <= 0 || i >= Settings.MAX_FORCE_FIELDS_PER_TICK) continue;
                        nbtList.func_74742_a((NBTBase)position.writeToNBT(new NBTTagCompound()));
                        ++i;
                    }
                    nbt.func_74774_a("type", (byte)1);
                    nbt.func_74782_a("list", (NBTBase)nbtList);
                    PacketManager.sendPacketToClients(PacketManager.getPacket("MFFS", this, new Object[]{TileEntityBase.TilePacketType.FXS.ordinal(), nbt}), this.field_70331_k, new Vector3(this), 60.0);
                }
            }
        }
    }

    public boolean isBlockVisible(Vector3 position) {
        int i = 0;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 checkPos = position.clone().modifyPositionFromSide(direction);
            int blockID = checkPos.getBlockID((IBlockAccess)this.field_70331_k);
            if (blockID <= 0 || Block.field_71973_m[blockID] == null || !Block.field_71973_m[blockID].func_71926_d()) continue;
            ++i;
        }
        return i < ForgeDirection.VALID_DIRECTIONS.length;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityBase.TilePacketType.FXS.ordinal() && this.field_70331_k.field_72995_K) {
            NBTTagCompound nbt = PacketManager.readNBTTagCompound(dataStream);
            byte type = nbt.func_74771_c("type");
            NBTTagList nbtList = (NBTTagList)nbt.func_74781_a("list");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                Vector3 vector = Vector3.readFromNBT((NBTTagCompound)nbtList.func_74743_b(i)).add(0.5);
                if (type == 1) {
                    ModularForceFieldSystem.proxy.renderHologram(this.field_70331_k, vector, 1.0f, 1.0f, 1.0f, 30, vector.clone().modifyPositionFromSide(this.getDirection((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)));
                    continue;
                }
                if (type != 2) continue;
                ModularForceFieldSystem.proxy.renderHologram(this.field_70331_k, vector, 1.0f, 0.0f, 0.0f, 30, vector.clone().modifyPositionFromSide(this.getDirection((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)));
                this.updatePushedObjects(0.022f);
            }
        } else if (packetID == TileEntityBase.TilePacketType.TOGGLE_MODE.ordinal() && !this.field_70331_k.field_72995_K) {
            this.anchor = null;
            this.func_70296_d();
        } else if (packetID == TileEntityBase.TilePacketType.TOGGLE_MODE_2.ordinal() && !this.field_70331_k.field_72995_K) {
            this.displayMode = (this.displayMode + 1) % 3;
        } else if (packetID == TileEntityBase.TilePacketType.TOGGLE_MODE_3.ordinal() && !this.field_70331_k.field_72995_K) {
            this.doAnchor = !this.doAnchor;
        }
    }

    @Override
    public int getFortronCost() {
        return (int)(((double)super.getFortronCost() + this.anchor.getMagnitude()) * 1000.0);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.isCalculated = false;
    }

    protected boolean canMove() {
        Set mobilizationPoints = this.getInteriorPoints();
        ForgeDirection dir = this.getDirection((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        block0: for (Vector3 position : mobilizationPoints) {
            if (position.getBlockID((IBlockAccess)this.field_70331_k) <= 0) continue;
            if (Blacklist.forceManipulationBlacklist.contains(Block.field_71973_m[position.getBlockID((IBlockAccess)this.field_70331_k)])) {
                return false;
            }
            TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_70331_k);
            if (tileEntity instanceof ISpecialForceManipulation && !((ISpecialForceManipulation)tileEntity).preMove(position.intX(), position.intY(), position.intZ())) {
                return false;
            }
            Vector3 targetPosition = position.clone().modifyPositionFromSide(dir);
            if (targetPosition.getTileEntity((IBlockAccess)this.field_70331_k) == this) {
                return false;
            }
            for (Vector3 checkPos : mobilizationPoints) {
                if (!checkPos.equals(targetPosition)) continue;
                continue block0;
            }
            int blockID = targetPosition.getBlockID((IBlockAccess)this.field_70331_k);
            if (blockID == 0 || blockID > 0 && (Block.field_71973_m[blockID].isBlockReplaceable(this.field_70331_k, targetPosition.intX(), targetPosition.intY(), targetPosition.intZ()) || Block.field_71973_m[blockID] instanceof BlockFluid)) continue;
            return false;
        }
        return true;
    }

    protected boolean moveBlock(Vector3 position, ForgeDirection direction) {
        if (!this.field_70331_k.field_72995_K) {
            Vector3 newPosition = position.clone().modifyPositionFromSide(direction);
            TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_70331_k);
            int blockID = position.getBlockID((IBlockAccess)this.field_70331_k);
            if (blockID > 0 && tileEntity != this) {
                this.getDelayedEvents().add(new BlockPreMoveDelayedEvent(this, 20, this.field_70331_k, position, newPosition));
                return true;
            }
        }
        return false;
    }

    public void updatePushedObjects(float amount) {
        ForgeDirection dir = this.getDirection((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        AxisAlignedBB axisalignedbb = this.getSearchAxisAlignedBB();
        if (axisalignedbb != null) {
            List entities = this.field_70331_k.func_72872_a(Entity.class, axisalignedbb);
            for (Entity entity : entities) {
                entity.func_70024_g((double)(amount * (float)dir.offsetX), (double)(amount * (float)dir.offsetY), (double)(amount * (float)dir.offsetZ));
            }
        }
    }

    public AxisAlignedBB getSearchAxisAlignedBB() {
        Vector3 positiveScale = new Vector3(this).add(this.getTranslation()).add(this.getPositiveScale());
        Vector3 negativeScale = new Vector3(this).add(this.getTranslation()).subtract(this.getNegativeScale());
        Vector3 minScale = new Vector3(Math.min(positiveScale.x, negativeScale.x), Math.min(positiveScale.y, negativeScale.y), Math.min(positiveScale.z, negativeScale.z));
        Vector3 maxScale = new Vector3(Math.max(positiveScale.x, negativeScale.x), Math.max(positiveScale.y, negativeScale.y), Math.max(positiveScale.z, negativeScale.z));
        return AxisAlignedBB.func_72332_a().func_72299_a((double)minScale.intX(), (double)minScale.intY(), (double)minScale.intZ(), (double)maxScale.intX(), (double)maxScale.intY(), (double)maxScale.intZ());
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0 || slotID == 1) {
            return itemStack.func_77973_b() instanceof ItemCard;
        }
        if (slotID == 2) {
            return itemStack.func_77973_b() instanceof IProjectorMode;
        }
        if (slotID >= 15) {
            return true;
        }
        return itemStack.func_77973_b() instanceof IModule;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.anchor = Vector3.readFromNBT(nbt.func_74775_l("anchor"));
        this.displayMode = nbt.func_74762_e("displayMode");
        this.doAnchor = nbt.func_74767_n("doAnchor");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.anchor != null) {
            nbt.func_74766_a("anchor", this.anchor.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74768_a("displayMode", this.displayMode);
        nbt.func_74757_a("doAnchor", this.doAnchor);
    }

    @Override
    public Vector3 getTranslation() {
        return super.getTranslation().clone().add(this.anchor);
    }

    public int func_70302_i_() {
        return 21;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"isActivate", "setActivate", "resetAnchor"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 2: {
                this.anchor = null;
                return null;
            }
        }
        return super.callMethod(computer, method, arguments);
    }
}

