package mods.immibis.core.commands;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public class TPSCommand extends CommandBase {
	
	static {
		TickRegistry.registerTickHandler(new TickHandler(), Side.SERVER);
	}
	
	{
		TickHandler.reset();
	}
	
	private static class TickHandler implements ITickHandler {
		
		private static List<Integer> tickTime = new LinkedList<Integer>();
		private static long lastTickTime = System.nanoTime();
		
		static void reset() {
			tickTime.clear();
			lastTickTime = System.nanoTime();
		}
		
		@Override
		public String getLabel() {
			return "Immibis Core TPS calculator";
		}
		
		@Override
		public EnumSet<TickType> ticks() {
			return EnumSet.of(TickType.SERVER);
		}
		
		@Override
		public void tickEnd(EnumSet<TickType> type, Object... tickData) {
		}
		
		@Override
		public void tickStart(EnumSet<TickType> type, Object... tickData) {
			long thisTime = System.nanoTime();
			long tickTimeNS = thisTime - lastTickTime;
			lastTickTime = thisTime;
			
			int tickTimeMS = (int)((tickTimeNS + 500000) / 1000000);
			if(tickTime.size() == 100)
				tickTime.remove(99);
			tickTime.add(0, tickTimeMS);
		}

		public static double getTPS100() {
			return 1000.0 / getTickTime(100);
		}
		public static double getTPS20() {
			return 1000.0 / getTickTime(20);
		}
		public static double getTPS5() {
			return 1000.0 / getTickTime(5);
		}
		public static double getTPS1() {
			return 1000.0 / getTickTime();
		}
		public static int getTickTime() {
			return tickTime.get(0);
		}
		
		private static double getTickTime(int avgTicks) {
			if(avgTicks > tickTime.size())
				return getTickTime(tickTime.size());
			
			int total = 0;
			Iterator<Integer> it = tickTime.iterator();
			for(int k = 0; k < avgTicks; k++)
				total += it.next();
			
			System.out.println("Sum of "+avgTicks+" ticks: "+total);
			
			return total / (double)avgTicks;
		}
	}

	@Override
	public String getCommandName() {
		return "tps";
	}

	@Override
	public void processCommand(ICommandSender icommandsender, String[] astring) {
		icommandsender.sendChatToPlayer(String.format("\u00A7eAverage TPS over last 200 ticks: \u00A7b%.2f", TickHandler.getTPS100()));
		icommandsender.sendChatToPlayer(String.format("\u00A7eAverage TPS over last 20 ticks: \u00A7b%.2f", TickHandler.getTPS20()));
		icommandsender.sendChatToPlayer(String.format("\u00A7eAverage TPS over last 5 ticks: \u00A7b%.2f", TickHandler.getTPS5()));
		icommandsender.sendChatToPlayer(String.format("\u00A7eTime between last two ticks: \u00A7b%dms\u00A7e (\u00A7b%.2f\u00A7e TPS)", TickHandler.getTickTime(), TickHandler.getTPS1()));
	}

	@Override
	public boolean canCommandSenderUseCommand(ICommandSender par1iCommandSender) {
		return true;
	}

}
