package mods.immibis.microblocks.crossmod;

import mods.immibis.microblocks.ItemMicroblock;
import mods.immibis.microblocks.MicroblockSystem;
import mods.immibis.microblocks.ModProperties;
import mods.immibis.microblocks.coremod.CoreModOptions;
import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;

public class NEIMicroblocksConfig implements IConfigureNEI {
	@Override
	public void loadConfig() {
		if(MicroblockSystem.instance != null) {
			try {
				if(CoreModOptions.enableNEI) {
					API.setMaxDamageException(MicroblockSystem.microblockContainerBlock.blockID, 1);
					for(int i : MicroblockSystem.neiPartIDs)
						API.addNBTItem(ItemMicroblock.getStackWithPartID(i));
					API.addSetRange("Blocks.Microblocks", new MultiItemRange().add(MicroblockSystem.microblockContainerBlock));
				
				} else {
					API.hideItem(MicroblockSystem.microblockContainerBlock.blockID);
				}
			} catch(Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String getName() {
		return "Immibis's Microblocks";
	}

	@Override
	public String getVersion() {
		return ModProperties.MOD_VERSION;
	}
}
